/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_3288;
import net.minecraft.class_4239;
import net.minecraft.class_7367;
import net.minecraft.class_8614;
import net.minecraft.class_9224;
import org.jetbrains.annotations.Nullable;

public class CombinedPackResources
extends class_3255 {
    private final class_3272 packInfo;
    private final List<class_3262> packs;
    private final Map<String, List<class_3262>> assets;
    private final Map<String, List<class_3262>> data;
    private final Path source;

    public CombinedPackResources(class_9224 id, class_3272 packInfo, List<? extends class_3262> packs, Path sourcePack) {
        super(id);
        this.packInfo = packInfo;
        this.packs = ImmutableList.copyOf(packs);
        this.assets = this.buildNamespaceMap(class_3264.field_14188, packs);
        this.data = this.buildNamespaceMap(class_3264.field_14190, packs);
        this.source = sourcePack;
    }

    private Map<String, List<class_3262>> buildNamespaceMap(class_3264 type, List<? extends class_3262> packList) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (class_3262 class_32622 : packList) {
            for (String namespace : class_32622.method_14406(type)) {
                map.computeIfAbsent(namespace, k -> new ArrayList()).add(class_32622);
            }
        }
        map.replaceAll((k, list) -> ImmutableList.copyOf((Collection)list));
        return ImmutableMap.copyOf(map);
    }

    public Path getSource() {
        return this.source;
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... paths) {
        class_4239.method_46345((String[])paths);
        Path path = class_4239.method_46344((Path)this.getSource(), List.of(paths));
        return Files.exists(path, new LinkOption[0]) ? class_7367.create((Path)path) : null;
    }

    @Nullable
    public <T> T method_14407(class_3270<T> deserializer) {
        return (T)(deserializer.method_14420().equals("pack") ? this.packInfo : null);
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 location) {
        for (class_3262 pack : this.getCandidatePacks(type, location)) {
            class_7367 ioSupplier = pack.method_14405(type, location);
            if (ioSupplier == null) continue;
            return ioSupplier;
        }
        return null;
    }

    public void method_14408(class_3264 type, String namespace, String path, class_3262.class_7664 output) {
        for (class_3262 delegate : this.packs) {
            delegate.method_14408(type, namespace, path, output);
        }
    }

    public Set<String> method_14406(class_3264 type) {
        return type == class_3264.field_14188 ? this.assets.keySet() : this.data.keySet();
    }

    public void close() {
        for (class_3262 pack : this.packs) {
            pack.close();
        }
    }

    @Nullable
    public Collection<class_3262> getChildren() {
        return this.packs;
    }

    private List<class_3262> getCandidatePacks(class_3264 type, class_2960 location) {
        Map<String, List<class_3262>> map = type == class_3264.field_14188 ? this.assets : this.data;
        List<class_3262> packsWithNamespace = map.get(location.method_12836());
        return packsWithNamespace == null ? Collections.emptyList() : packsWithNamespace;
    }

    public String toString() {
        return String.format("%s: %s", ((Object)((Object)this)).getClass().getName(), this.getSource());
    }

    public record CombinedResourcesSupplier(class_3272 packInfo, List<? extends class_3262> packs, Path sourcePack) implements class_3288.class_7680
    {
        public class_3262 method_52424(class_9224 location) {
            return new CombinedPackResources(location, this.packInfo, this.packs, this.sourcePack);
        }

        public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
            class_3262 packresources = this.method_52424(location);
            List list = metadata.comp_1584();
            if (list.isEmpty()) {
                return packresources;
            }
            ArrayList<CombinedPackResources> list1 = new ArrayList<CombinedPackResources>(list.size());
            for (String s : list) {
                Path path = this.sourcePack.resolve(s);
                list1.add(new CombinedPackResources(location, this.packInfo, this.packs, path));
            }
            return new class_8614(packresources, list1);
        }
    }
}

